/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.dialogos.compras;

import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.validacion.ContextoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidableContexto;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionModeloDialogo;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.VistaValoresPropios;
import ec.gob.sri.dimm.api.ui.dialogos.DialogoBase;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.ats.modelo.catalogos.ConceptosRetencionBanano;
import ec.gob.sri.dimm.ats.modelo.catalogos.Dividendos;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.asistente.valores.ModeloValoresAir;
import ec.gob.sri.dimm.ats.modelo.obj.compras.DetalleAirCompras;
import ec.gob.sri.dimm.ats.modelo.obj.compras.TransaccionCompra;
import ec.gob.sri.dimm.ats.modelo.util.InfoPantallas;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.wb.swt.SWTResourceManager;

public class DialogoDetalleAirCompra
extends DialogoBase
implements VistaModelo<DetalleAirCompras>,
VistaValoresPropios {
    private DataBindingContext m_bindingContext;
    private ModeloValoresAir modeloValores;
    private ListenerValidacionModeloDialogo listenerValidacionModelo;
    private DetalleAirCompras modeloDatos;
    private TransaccionCompra compraSeleccionada;
    private Text txtBaseImponible;
    private Text txtPorcentaje;
    private Text txtMontoRetencion;
    private ComboViewer cvConceptos;
    private Text txtIRDividendo;
    private Text txtAnio;
    private Composite cDividendo;
    private boolean editando;
    private List<String> codigosExistentes;
    private String codigoActual = "";
    private final Periodo periodo;
    private final String esMicroEmpresa;
    private final Date fechaSeleccContable;
    private Text txtPrecioCaja;
    private Text txtCantidadCajas;
    private Composite compositeBanano;

    public DialogoDetalleAirCompra(IWorkbenchPartSite site, List<String> codigosComp, boolean editando, Periodo Periodo2, String esMicroEmpresa, Date fechaSeleccContable) {
        super(site);
        this.periodo = Periodo2;
        this.esMicroEmpresa = esMicroEmpresa;
        this.setShellStyle(65616);
        this.editando = editando;
        this.codigosExistentes = codigosComp;
        this.fechaSeleccContable = fechaSeleccContable;
    }

    public void inicializarModeloValores() {
        this.modeloValores = new ModeloValoresAir(this.periodo, this.esMicroEmpresa, this.fechaSeleccContable, this.compraSeleccionada);
        this.modeloValores.inicializar();
    }

    public void setModeloDatos(DetalleAirCompras modeloDatos) {
        this.modeloDatos = modeloDatos;
        if (this.editando) {
            this.codigoActual = modeloDatos.getConceptoRetencion();
        }
    }

    public boolean close() {
        this.modeloDatos.removePropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
        return super.close();
    }

    public void procesarModeloDatos() {
        String codigoTipoConcepto = this.modeloDatos.getConceptoRetencion();
        ElementoNombreValor tipoConcepto = this.modeloValores.obtenerTipoConcepto(codigoTipoConcepto);
        AyudanteViewer.seleccionarElemento((Viewer)this.cvConceptos, (Object)tipoConcepto);
        this.cDividendo.setVisible(false);
        this.compositeBanano.setVisible(false);
        if (codigoTipoConcepto != null) {
            this.mostrarPanelDividendosPorTipoConcepto((ElementoNombreValor<String[]>)tipoConcepto);
            this.mostrarPanelParaExportadoresBananeros((ElementoNombreValor<String[]>)tipoConcepto);
        }
        if (tipoConcepto != null) {
            this.bloquearPorcentajeYMontoDeRetencionPorCodigoDeRetencion((ElementoNombreValor<String[]>)tipoConcepto);
            this.procesarSustentosEspeciales_323();
        }
        ContextoValidacion ctx = new ContextoValidacion();
        ctx.agregar(InfoPantallas.AIR_ACTUAL.toString(), (Object)this.codigoActual);
        ctx.agregar(InfoPantallas.AIR_EXISTENTES.toString(), this.codigosExistentes);
        this.listenerValidacionModelo = new ListenerValidacionModeloDialogo((InformacionValidableContexto)this.modeloDatos, ctx, (DialogoBase)this);
        this.modeloDatos.addPropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
    }

    public TransaccionCompra getCompraSeleccionada() {
        return this.compraSeleccionada;
    }

    public void setCompraSeleccionada(TransaccionCompra compraSeleccionada) {
        this.compraSeleccionada = compraSeleccionada;
    }

    private void bloquearPorcentajeYMontoDeRetencionPorCodigoDeRetencion(ElementoNombreValor<String[]> tipoConcepto) {
        boolean esDividendoYEsPeriodoDesdeMar2015aJul2015;
        boolean esDividendoNaturalesYEsPeriodoEne2013aFeb2015 = Dividendos.RETENCIONES_CON_DIVIDENDOS_NATURALES_2013_FEB_2015.containsKey(((String[])tipoConcepto.getValor())[0]) && this.periodo.isPeridoDeAnexoDesdeEnero2013aFebrero2015();
        boolean bl = esDividendoYEsPeriodoDesdeMar2015aJul2015 = Dividendos.RETENCIONES_CON_DIVIDENDOS_DESDE_MARZO_2015.containsKey(((String[])tipoConcepto.getValor())[0]) && this.periodo.isPeriodoDesdeMarzo2015AJulio2015();
        if (esDividendoNaturalesYEsPeriodoEne2013aFeb2015 || esDividendoYEsPeriodoDesdeMar2015aJul2015) {
            this.txtPorcentaje.setEditable(false);
            this.txtMontoRetencion.setEditable(false);
        } else {
            if (tipoConcepto.getEtiqueta().substring(0, 4).equals("504F") || tipoConcepto.getEtiqueta().substring(0, 4).equals("504H")) {
                this.txtPorcentaje.setEditable(true);
            } else {
                this.txtPorcentaje.setEditable(((String[])tipoConcepto.getValor())[1] == null || this.esRetencionDeBanano(tipoConcepto));
            }
            this.txtMontoRetencion.setEditable(true);
        }
    }

    private boolean esRetencionDeBanano(ElementoNombreValor<String[]> tipoConcepto) {
        return this.periodo.isPeriodoDeAnexoDesdeMarzo2015() && ConceptosRetencionBanano.RETENCIONES_EXPORTADORES_BANANEROS_DESDE_MARZO_2015.containsKey(((String[])tipoConcepto.getValor())[0]);
    }

    private void mostrarPanelParaExportadoresBananeros(ElementoNombreValor<String[]> tipoConcepto) {
        if (this.esRetencionDeBanano(tipoConcepto)) {
            this.txtBaseImponible.setEditable(false);
            this.txtPorcentaje.setEditable(false);
            this.compositeBanano.setVisible(this.periodo.isPeriodoDeAnexoDesdeMarzo2015());
        } else {
            this.txtBaseImponible.setEditable(true);
            this.compositeBanano.setVisible(false);
            this.modeloDatos.setNumeroCajasDeBanano("000");
            this.modeloDatos.setPrecioCajaDeBanano("0.00");
        }
    }

    private void mostrarPanelDividendosPorTipoConcepto(ElementoNombreValor<String[]> tipoConcepto) {
        this.cDividendo.setVisible(this.periodo.isPeridoDeAnexoDesdeEnero2013aFebrero2015() && Dividendos.RETENCIONES_CON_DIVIDENDOS_NATURALES_2013_FEB_2015.containsKey(((String[])tipoConcepto.getValor())[0]));
        if (this.periodo.isPeriodoDeAnexoDesdeMarzo2015()) {
            this.cDividendo.setVisible(Dividendos.RETENCIONES_CON_DIVIDENDOS_DESDE_MARZO_2015.containsKey(((String[])tipoConcepto.getValor())[0]));
        }
    }

    private void calcularRetencionBanano(String concepto) {
        BigDecimal numeroCajas = new BigDecimal(this.modeloDatos.getNumeroCajasDeBanano());
        BigDecimal precioCaja = new BigDecimal(this.modeloDatos.getPrecioCajaDeBanano());
        BigDecimal valorFacturadoBanano = numeroCajas.multiply(precioCaja);
        try {
            Map valoresRetencionBanano = this.modeloValores.obtenerTarifaEfectivaRetencionBanano(concepto, Double.parseDouble(this.modeloDatos.getNumeroCajasDeBanano()), precioCaja, Double.parseDouble(this.modeloDatos.getPorcentajeRetencion()));
            this.modeloDatos.setBaseImponibleRenta(valorFacturadoBanano.setScale(2, 0).toString());
            this.modeloDatos.setPorcentajeRetencionCalculoBanano((BigDecimal)valoresRetencionBanano.get("porcentajeRetenido"));
            this.modeloDatos.setValorRetenidoPorBanano((BigDecimal)valoresRetencionBanano.get("valorRetenido"));
            this.modeloDatos.setPorcentajeRetencion("0.00");
            this.modeloDatos.setPorcentajeRetencion(((BigDecimal)valoresRetencionBanano.get("porcentajeRetenido")).setScale(2, 4).toString());
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage("Debe ingresar solo valores enteros en el n\u00famero de cajas de banano");
        }
    }

    private void procesarSustentosEspeciales_323() {
        if (this.modeloDatos.getConceptoRetencion().equals(Sustentos.SUS_323E2.getCodigo())) {
            this.modeloDatos.setPorcentajeRetencion(Sustentos.SUS_323E2.getPorcentaje());
            this.txtPorcentaje.setEditable(Sustentos.SUS_323E2.isEditable());
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage("Ingrese los valores de las Retenciones de Impuesto a la Renta");
        this.setTitle("Retenci\u00f3n en la Fuente Impuesto a la Renta");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Label lblConceptoDeRetencin = new Label(container, 0);
        lblConceptoDeRetencin.setText("Concepto de Retenci\u00f3n");
        this.cvConceptos = new ComboViewer(container, 8);
        this.manejarSeleccionConceptoDeRetencion();
        Combo combo = this.cvConceptos.getCombo();
        GridData gd_combo = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_combo.widthHint = 150;
        combo.setLayoutData((Object)gd_combo);
        Label lblBaseImponibleImpuesto = new Label(container, 0);
        GridData gd_lblBaseImponibleImpuesto = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblBaseImponibleImpuesto.widthHint = 210;
        lblBaseImponibleImpuesto.setLayoutData((Object)gd_lblBaseImponibleImpuesto);
        lblBaseImponibleImpuesto.setText("Base Imponible Renta");
        this.txtBaseImponible = new Text(container, 2048);
        this.txtBaseImponible.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoDetalleAirCompra.this.txtBaseImponible.selectAll();
            }
        });
        this.txtBaseImponible.setTextLimit(15);
        GridData gd_txtBaseImponible = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtBaseImponible.widthHint = 125;
        this.txtBaseImponible.setLayoutData((Object)gd_txtBaseImponible);
        Label lblPorcentajeRetencin = new Label(container, 0);
        lblPorcentajeRetencin.setText("Porcentaje Retenci\u00f3n");
        this.txtPorcentaje = new Text(container, 2048);
        this.txtPorcentaje.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoDetalleAirCompra.this.txtPorcentaje.selectAll();
            }
        });
        this.txtPorcentaje.setTextLimit(5);
        GridData gd_txtPorcentaje = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtPorcentaje.widthHint = 125;
        this.txtPorcentaje.setLayoutData((Object)gd_txtPorcentaje);
        Label lblMontoDeRetencin = new Label(container, 0);
        lblMontoDeRetencin.setText("Monto de Retenci\u00f3n");
        this.txtMontoRetencion = new Text(container, 2048);
        this.txtMontoRetencion.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoDetalleAirCompra.this.txtMontoRetencion.selectAll();
            }
        });
        this.txtMontoRetencion.setTextLimit(15);
        GridData gd_txtMontoRetencion = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtMontoRetencion.widthHint = 125;
        this.txtMontoRetencion.setLayoutData((Object)gd_txtMontoRetencion);
        this.cDividendo = new Composite(container, 0);
        GridLayout gl_cDividendo = new GridLayout(2, false);
        gl_cDividendo.verticalSpacing = 3;
        gl_cDividendo.marginWidth = 0;
        this.cDividendo.setLayout((Layout)gl_cDividendo);
        this.cDividendo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        Label lblInformacinDelDividendo = new Label(this.cDividendo, 0);
        lblInformacinDelDividendo.setFont(SWTResourceManager.getFont((String)"Segoe UI", (int)9, (int)1));
        GridData gd_lblInformacinDelDividendo = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblInformacinDelDividendo.verticalIndent = 10;
        lblInformacinDelDividendo.setLayoutData((Object)gd_lblInformacinDelDividendo);
        lblInformacinDelDividendo.setText("Informaci\u00f3n del Dividendo");
        new Label(this.cDividendo, 0);
        Label lblFechaDelPago = new Label(this.cDividendo, 0);
        GridData gd_lblFechaDelPago = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblFechaDelPago.widthHint = 200;
        lblFechaDelPago.setLayoutData((Object)gd_lblFechaDelPago);
        lblFechaDelPago.setText("Fecha del Pago del Dividendo");
        final CDateTime dtFechaPagoDividendo = new CDateTime(this.cDividendo, 32771);
        dtFechaPagoDividendo.setNullText("seleccione la fecha");
        dtFechaPagoDividendo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        dtFechaPagoDividendo.setPattern("dd/MM/yyyy");
        dtFechaPagoDividendo.setSelection(this.modeloDatos.getFechaPagoDividendo());
        dtFechaPagoDividendo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DialogoDetalleAirCompra.this.modeloDatos.setFechaPagoDividendo(dtFechaPagoDividendo.getSelection());
            }
        });
        Label lblIrAsociadoAl = new Label(this.cDividendo, 0);
        lblIrAsociadoAl.setText("IR asociado al Dividendo");
        this.txtIRDividendo = new Text(this.cDividendo, 2048);
        this.txtIRDividendo.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoDetalleAirCompra.this.txtIRDividendo.selectAll();
            }
        });
        this.txtIRDividendo.setTextLimit(15);
        GridData gd_txtIRDividendo = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtIRDividendo.widthHint = 125;
        this.txtIRDividendo.setLayoutData((Object)gd_txtIRDividendo);
        Label lblAoltimoDividendo = new Label(this.cDividendo, 0);
        GridData gd_lblAoltimoDividendo = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblAoltimoDividendo.widthHint = 210;
        lblAoltimoDividendo.setLayoutData((Object)gd_lblAoltimoDividendo);
        lblAoltimoDividendo.setText("A\u00f1o en que se generaron las utilidades");
        this.txtAnio = new Text(this.cDividendo, 2048);
        this.txtAnio.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoDetalleAirCompra.this.txtAnio.selectAll();
            }
        });
        this.txtAnio.setTextLimit(4);
        this.txtAnio.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.compositeBanano = new Composite(container, 0);
        this.compositeBanano.setLayout((Layout)new GridLayout(3, false));
        GridData gd_compositeBanano = new GridData(16384, 0x1000000, false, false, 2, 1);
        gd_compositeBanano.widthHint = 511;
        this.compositeBanano.setLayoutData((Object)gd_compositeBanano);
        Label lblCantidadDeCajas = new Label(this.compositeBanano, 0);
        lblCantidadDeCajas.setText("Cantidad de cajas estandar de banano  ");
        this.txtCantidadCajas = new Text(this.compositeBanano, 2048);
        this.txtCantidadCajas.setTextLimit(10);
        GridData gd_txtCantidadCajas = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtCantidadCajas.widthHint = 155;
        this.txtCantidadCajas.setLayoutData((Object)gd_txtCantidadCajas);
        Button btnCalcularImpuesto = new Button(this.compositeBanano, 0);
        this.botonCalcularOnClick(btnCalcularImpuesto);
        btnCalcularImpuesto.setText("Calcular Impuesto");
        Label lblPrecioDeLa = new Label(this.compositeBanano, 0);
        lblPrecioDeLa.setText("Precio de la caja de banano");
        this.txtPrecioCaja = new Text(this.compositeBanano, 2048);
        this.txtPrecioCaja.setTextLimit(5);
        this.txtPrecioCaja.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(this.compositeBanano, 0);
        this.m_bindingContext = this.initDataBindings();
        this.procesarModeloDatos();
        return area;
    }

    private void botonCalcularOnClick(Button btnCalcularImpuesto) {
        btnCalcularImpuesto.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                DialogoDetalleAirCompra.this.calcularRetencionBanano(DialogoDetalleAirCompra.this.modeloDatos.getConceptoRetencion());
            }
        });
    }

    private void manejarSeleccionConceptoDeRetencion() {
        this.cvConceptos.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor tipoConcepto = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (tipoConcepto != null) {
                    this.seleccionarConceptoDeRetencionEnCombo((ElementoNombreValor<String[]>)tipoConcepto);
                    this.setearPorcentajeDeRetencionCuandoHayCambioDeSeleccionDeConcepto((ElementoNombreValor<String[]>)tipoConcepto);
                    DialogoDetalleAirCompra.this.mostrarPanelDividendosPorTipoConcepto((ElementoNombreValor<String[]>)tipoConcepto);
                    DialogoDetalleAirCompra.this.mostrarPanelParaExportadoresBananeros((ElementoNombreValor<String[]>)tipoConcepto);
                    DialogoDetalleAirCompra.this.bloquearPorcentajeYMontoDeRetencionPorCodigoDeRetencion((ElementoNombreValor<String[]>)tipoConcepto);
                    DialogoDetalleAirCompra.this.procesarSustentosEspeciales_323();
                }
            }

            private void setearPorcentajeDeRetencionCuandoHayCambioDeSeleccionDeConcepto(ElementoNombreValor<String[]> tipoConcepto) {
                if (!DialogoDetalleAirCompra.this.modeloDatos.getConceptoRetencion().equals(DialogoDetalleAirCompra.this.codigoActual)) {
                    DialogoDetalleAirCompra.this.modeloDatos.setPorcentajeRetencion(((String[])tipoConcepto.getValor())[1] == null ? "0.00" : ((String[])tipoConcepto.getValor())[1]);
                }
            }

            private void seleccionarConceptoDeRetencionEnCombo(ElementoNombreValor<String[]> tipoConcepto) {
                DialogoDetalleAirCompra.this.modeloDatos.setConceptoRetencion(((String[])tipoConcepto.getValor())[0]);
                DialogoDetalleAirCompra.this.modeloDatos.setDescripcionConcepto(tipoConcepto.getNombre());
            }
        });
    }

    protected Point getInitialSize() {
        return new Point(660, 440);
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap observeMap = PojoObservables.observeMap((IObservableSet)listContentProvider.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvConceptos.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap));
        this.cvConceptos.setContentProvider((IContentProvider)listContentProvider);
        IObservableList tiposDeConceptosModeloValoresObserveList = PojoProperties.list((String)"tiposDeConceptos").observe((Object)this.modeloValores);
        this.cvConceptos.setInput((Object)tiposDeConceptosModeloValoresObserveList);
        ISWTObservableValue observeTextTxtBaseImponibleObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtBaseImponible);
        IObservableValue baseImponibleRentaModeloDatosObserveValue = BeanProperties.value((String)"baseImponibleRenta").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtBaseImponibleObserveWidget, baseImponibleRentaModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtMontoRetencionObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtMontoRetencion);
        IObservableValue valorRetenidoModeloDatosObserveValue = BeanProperties.value((String)"valorRetenido").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtMontoRetencionObserveWidget, valorRetenidoModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtIRDividendoObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtIRDividendo);
        IObservableValue impuestoRentaSociedadModeloDatosObserveValue = BeanProperties.value((String)"impuestoRentaSociedad").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtIRDividendoObserveWidget, impuestoRentaSociedadModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtAnioObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtAnio);
        IObservableValue anioUtilidadesDivModeloDatosObserveValue = BeanProperties.value((String)"anioUtilidadesDiv").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtAnioObserveWidget, anioUtilidadesDivModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtPorcentajeObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtPorcentaje);
        IObservableValue porcentajeRetencionModeloDatosObserveValue = BeanProperties.value((String)"porcentajeRetencion").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtPorcentajeObserveWidget, porcentajeRetencionModeloDatosObserveValue, null, null);
        ISWTObservableValue txtCantidadCajasObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtCantidadCajas, (int)24);
        IObservableValue modeloDatosNumeroCajasDeBananoObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"numeroCajasDeBanano");
        bindingContext.bindValue((IObservableValue)txtCantidadCajasObserveTextObserveWidget, modeloDatosNumeroCajasDeBananoObserveValue, null, null);
        ISWTObservableValue txtPrecioCajaObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtPrecioCaja, (int)24);
        IObservableValue modeloDatosPrecioCajaDeBananoObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"precioCajaDeBanano");
        bindingContext.bindValue((IObservableValue)txtPrecioCajaObserveTextObserveWidget, modeloDatosPrecioCajaDeBananoObserveValue, null, null);
        return bindingContext;
    }

    public static enum Sustentos {
        SUS_323E2("323E2", "0.00", false);

        private String codigo;
        private String porcentaje;
        private boolean editable;

        private Sustentos(String codigo, String porcentaje, boolean editable) {
            this.codigo = codigo;
            this.porcentaje = porcentaje;
            this.editable = editable;
        }

        public String getCodigo() {
            return this.codigo;
        }

        public String getPorcentaje() {
            return this.porcentaje;
        }

        public boolean isEditable() {
            return this.editable;
        }
    }
}

